/*
 * Decompiled with CFR 0.152.
 */
package blue.lhf.bytecraft;

import blue.lhf.bytecraft.BytecraftProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.byteskript.skript.runtime.Skript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecraftBootstrap {
    public static Logger LOGGER;

    public static void load(Skript skript) throws URISyntaxException, IOException {
        CodeSource source = BytecraftBootstrap.class.getProtectionDomain().getCodeSource();
        if (source == null) {
            throw new IllegalStateException("Cannot find bootstrap code source");
        }
        URL sourceUrl = source.getLocation();
        LOGGER.info("Loading ByteCraft libraries...");
        Path tempDir = Files.createTempDirectory("bytecraft", new FileAttribute[0]);
        ArrayList<URL> collectedUrls = new ArrayList<URL>();
        try (FileSystem zip = FileSystems.newFileSystem(new URI("jar:" + String.valueOf(sourceUrl.toURI())), Map.of());){
            PathMatcher matcher = zip.getPathMatcher("glob:/lib/**.jar");
            for (Path root : zip.getRootDirectories()) {
                Stream<Path> files = Files.walk(root, new FileVisitOption[0]).filter(matcher::matches);
                try {
                    for (Path path : files::iterator) {
                        Path targetPath = tempDir;
                        for (Path component : path) {
                            targetPath = targetPath.resolve(component.toString());
                        }
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        Files.copy(path, targetPath, new CopyOption[0]);
                        collectedUrls.add(targetPath.toUri().toURL());
                    }
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
        }
        URLClassLoader classLoader = new URLClassLoader(collectedUrls.toArray(new URL[0]), BytecraftBootstrap.class.getClassLoader());
        ServiceLoader.load(BytecraftProvider.class, classLoader).forEach(provider -> provider.register(skript));
        LOGGER.info("Successfully loaded ByteCraft and " + collectedUrls.size() + " libraries!");
        LOGGER.info("Welcome to ByteCraft.");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                classLoader.close();
                Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    @NotNull
                    public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                        Files.deleteIfExists(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    @NotNull
                    public FileVisitResult visitFileFailed(@NotNull Path file, @NotNull IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    @NotNull
                    public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) throws IOException {
                        Files.deleteIfExists(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    static {
        try {
            LogManager.getLogManager().readConfiguration(BytecraftBootstrap.class.getResourceAsStream("/logging.properties"));
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        LOGGER = Logger.getLogger(BytecraftBootstrap.class.getName());
    }
}

